
//Direct Sequence Spread Spectrum(DS-BPSK)
//OS:Windows 10
//Scilab 5.5.2

clear all;
clc;
close;

function[st,mt]= DS_Spread_Spectrum(bt,ct_polar) 
//Generation of waveforms in DS/BPSK spread spectrum transmitter
//bt: Input Data Sequence (bipolar format)
//ct_polar: Spreading code (bipolar format)
Ft = 0:0.01:1; 
//bt = [1*ones(1,N) -1*ones(1,N)];
t = 0:length(bt)-1;
//ct_polar = [-1,-1,1,1,1,-1,1,-1,-1,1,1,1,-1,1];
mt = bt.*ct_polar;
Carrier = 2*sin(Ft*2*%pi);
st = [];
for i = 1:length(mt)
  st = [st mt(i)*Carrier];
end

figure
subplot(3,1,1)
a =gca();
a.x_location = "origin";
a.y_location = "origin";
a.data_bounds = [0,-2;20,2];
plot2d2(t,bt,5)
xlabel('                                                                              t')
ylabel('                                                                               b(t)')
title('Data')
subplot(3,1,2)
a =gca();
a.x_location = "origin";
a.y_location = "origin";
a.data_bounds = [0,-2;20,2];
plot2d2(t,ct_polar,5)
xlabel('                                                                              t')
ylabel('                                                                               c(t)')
title('Spreading code')
subplot(3,1,3)
a =gca();
a.x_location = "origin";
a.y_location = "origin";
a.data_bounds = [0,-2;20,2];
plot2d2(t,mt,5)
xlabel('                                                                              t')
ylabel('                                                                               m(t)')
title('Product Signal')

figure
subplot(3,1,1)
a =gca();
a.x_location = "origin";
a.y_location = "origin";
a.data_bounds = [0,-2;20,2];
plot2d2(t,mt,5)
xlabel('                                                                              t')
ylabel('                                                                               m(t)')
title('Product Signal')
subplot(3,1,2)
a =gca();
a.x_location = "origin";
a.y_location = "origin";
a.data_bounds = [0,-2;20,2];
plot(Carrier)
xlabel('                                                                              t')
ylabel('                                                                               c(t)')
title('Carrier Signal')
subplot(3,1,3)
a =gca();
a.x_location = "origin";
a.y_location = "origin";
a.data_bounds = [0,-2;20,2];
plot(st)
xlabel('                                                                             t')
ylabel('                                                                               s(t)')
title('DS/BPSK signal')
endfunction

bt = [1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1]
ct_polar = [-1,-1,1,1,1,-1,1,-1,-1,1,1,1,-1,1]
[st,mt]= DS_Spread_Spectrum(bt,ct_polar)
